<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('conveyancings', function (Blueprint $table) {
            $table->id();
            //relationship with clients
            $table->foreignId('client_id')->constrained()->cascadeOnDelete();
            $table->string('property_address');
            $table->string('serial_number')->unique()->nullable();
           // Buyer and seller now link to clients
            $table->foreignId('seller_id')->nullable()->constrained('clients')->nullOnDelete();
            $table->foreignId('buyer_id')->nullable()->constrained('clients')->nullOnDelete();

            $table->decimal('sale_price', 15, 2);
            $table->decimal('buyer_legal_fees', 10, 2)->nullable();
            $table->decimal('seller_legal_fees', 10, 2)->nullable();
            $table->enum('status', ['pending', 'in_progress', 'completed', 'cancelled'])->default('pending');
            $table->date('contract_date')->nullable();
            $table->date('completion_period')->nullable();
            $table->text('notes')->nullable();
            $table->softDeletes();//enable soft deletes
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('conveyancings');
    }
};
