<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('litigation_activities', function (Blueprint $table) {
            $table->id();
            $table->foreignId('litigation_id')->constrained()->cascadeOnDelete();
            $table->string("activity");
            $table->string("court_room");
            $table->text("outcome");
            $table->date('activity_date')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('litigation_stages');
    }
};
