<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('litigation_advocates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('litigation_id')->constrained()->cascadeOnDelete();

            $table->string('party');         // Name or identifier of the party
            $table->string('party_type');    // e.g. Plaintiff, Defendant
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('gender')->nullable();

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('litigation_advocates');
    }
};
