<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('litigations', function (Blueprint $table) {
            $table->id();
            //system generated
            $table->string('case_number')->unique()->nullable();
            $table->string('court_assigned_case_number')->nullable();
            $table->text('description')->nullable();

            $table->integer('amount_charged')->nullable();
            
            $table->foreignId('litigation_case_type_id')->constrained()->cascadeOnDelete();
            $table->foreignId('litigation_category_id')->constrained()->cascadeOnDelete();

            $table->string('station')->nullable();
            $table->date('filing_date')->nullable();  
            //Foreign Ids
            $table->unsignedBigInteger('client_id');
            $table->foreign('client_id')->references('id')->on('clients')->onDelete('cascade');
            //Timestamps
            $table->softDeletes();//enable soft deletes
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('litigations');
    }
};
