<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_client_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_client_id')->constrained()->cascadeOnDelete();
            $table->foreignId('payment_id')->nullable()->constrained('payments')->onDelete('set null');
            $table->integer('amount_paid')->nullable();
            $table->enum('payment_method',['mpesa','bank','cash']);
            $table->string('transaction_id')->nullable()->unique();
            //$table->enum('status',['pending','completed','failed']);
            //$table->string('type');
            $table->softDeletes();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_client_payments');
    }
};
