<?php

namespace Database\Factories;

use App\Models\SubDivisionDetail;
use App\Models\Project;
use App\Models\ProjectClient;
use Illuminate\Database\Eloquent\Factories\Factory;

class SubDivisionDetailFactory extends Factory
{
    protected $model = SubDivisionDetail::class;

    public function definition(): array
    {
        $project = Project::factory()->subdivision()->create(); // ensure type matches
        $projectClient = ProjectClient::factory()->for($project)->create();

        return [
            'project_id' => $project->id,
            'project_client_id' => $projectClient->id,
            'plot_number' => $this->faker->unique()->bothify('Plot-###'),
            'size' => $this->faker->numberBetween(100, 1000), // square meters
            'amount_charged' => $this->faker->randomFloat(2, 5000, 500000),
            'owner2' => $this->faker->name(),
        ];
    }

    public function forClient(ProjectClient $client)
    {
        return $this->state(fn(array $attributes) => [
            'project_client_id' => $client->id,
            'project_id' => $client->project_id,
        ]);
    }
}
