<?php

namespace Database\Factories;

use App\Models\Salary;
use App\Models\Employee;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Salary>
 */
class SalaryFactory extends Factory
{
    protected $model = Salary::class;

    public function definition(): array
    {
        return [
            'employee_id' => Employee::factory(), // creates or links to an employee
            'amount' => $this->faker->numberBetween(30000, 200000), // adjust salary range as needed
            'period' => $this->faker->dateTimeBetween('-1 years', 'now')->format('Y-m'), // e.g. "2025-08"
        ];
    }
}
