<?php

namespace Database\Factories;

use App\Models\Client;
use App\Models\Quotation;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<\App\Models\Quotation>
 */
class QuotationFactory extends Factory
{
    protected $model = Quotation::class;

    public function definition(): array
    {
        return [
            'client_id'   => Client::factory(), // create a related client automatically
            'type'        => $this->faker->randomElement(['conveyancing', 'litigation', 'project']),
            'details'     => $this->faker->sentence(10),
            'amount'      => $this->faker->randomFloat(2, 5000, 100000), // between 5k and 100k
            'quote_date'  => $this->faker->date(),
            'status'      => $this->faker->randomElement(['draft', 'sent', 'accepted', 'rejected']),
            // quote_number is auto-generated in booted() after creation
        ];
    }

    /**
     * Indicate that the quotation is already accepted.
     */
    public function accepted(): static
    {
        return $this->state(fn () => ['status' => 'accepted']);
    }

    /**
     * Indicate that the quotation is rejected.
     */
    public function rejected(): static
    {
        return $this->state(fn () => ['status' => 'rejected']);
    }
}
