<?php

namespace Database\Factories;

use App\Models\Project;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProjectFactory extends Factory
{
    protected $model = Project::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->company . ' ' . $this->faker->word,
            'description' => $this->faker->paragraph(),
            'poc' => $this->faker->name(),
            'location' => $this->faker->city(),
            'type' => $this->faker->randomElement(['sub_division', 'apartment']),
            'number_of_units' => $this->faker->numberBetween(1, 50),
            // serial_number will be auto-generated in model booted()
        ];
    }

    /**
     * State for apartment type
     */
    public function apartment(): static
    {
        return $this->state(fn (array $attributes) => [
            'type' => 'apartment',
        ]);
    }

    /**
     * State for subdivision type
     */
    public function subdivision(): static
    {
        return $this->state(fn (array $attributes) => [
            'type' => 'sub_division',
        ]);
    }
}
