<?php

namespace Database\Factories;

use App\Models\Project;
use App\Models\ProjectExpense;
use App\Models\Expense;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ProjectExpense>
 */
class ProjectExpenseFactory extends Factory
{
    protected $model = ProjectExpense::class;

    public function definition(): array
    {
        return [
            'project_id' => Project::factory(), // creates a related project client
            'expense_id' => Expense::factory(),      // creates a related expense
        ];
    }
}
