<?php

namespace Database\Factories;

use App\Models\ProjectClientPayment;
use App\Models\ProjectClient;
use App\Models\Payment;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProjectClientPaymentFactory extends Factory
{
    protected $model = ProjectClientPayment::class;

    public function definition(): array
    {
        return [
            'project_client_id' => ProjectClient::factory(),
            'payment_id' => function (array $attributes) {
                $projectClientId = $attributes['project_client_id'] ?? ProjectClient::factory()->create()->id;
                return Payment::factory()->forProjectClient(ProjectClient::find($projectClientId))->create()->id;
            },
            'amount_paid' => $this->faker->randomFloat(2, 1000, 50000),
            'payment_method' => $this->faker->randomElement(['cash', 'mpesa', 'bank']),
            'transaction_id' => strtoupper($this->faker->bothify('TRX###??##')),
            //'status' => $this->faker->randomElement(['pending', 'completed', 'failed']),
        ];
    }

    public function forProjectClient(ProjectClient $projectClient): static
    {
        return $this->state(fn (array $attributes) => [
            'project_client_id' => $projectClient->id,
            'payment_id' => Payment::factory()->forProjectClient($projectClient)->create()->id,
        ]);
    }
}