<?php

namespace Database\Factories;

use App\Models\ProjectClient;
use App\Models\Project;
use App\Models\Client;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ProjectClient>
 */
class ProjectClientFactory extends Factory
{
    protected $model = ProjectClient::class;

    public function definition(): array
    {
        return [
            'project_id' => Project::factory(), // will create a Project if not provided
            'client_id'  => Client::factory(),  // will create a Client if not provided
        ];
    }
}
