<?php

namespace Database\Factories;

use App\Models\Payment;
use App\Models\Client;
use App\Models\Account;
use App\Models\Conveyancing;
use App\Models\Litigation;
use App\Models\ProjectClient;
use Illuminate\Database\Eloquent\Factories\Factory;

class PaymentFactory extends Factory
{
    protected $model = Payment::class;

    public function definition(): array
    {
        return [
            'client_id' => Client::factory(),
            'account_id' => Account::factory(),
            'payable_id' => null, // polymorphic, to be overridden
            'payable_type' => null, // polymorphic, to be overridden
            'amount_paid' => $this->faker->randomFloat(2, 1000, 100000),
            'payment_method' => $this->faker->randomElement(['cash', 'mpesa', 'bank_transfer']),
            'transaction_id' => strtoupper($this->faker->bothify('TXN-####??')),
            'direction' => $this->faker->randomElement(['inflow', 'outflow']),
            //'status' => $this->faker->randomElement(['pending', 'completed', 'failed']),
        ];
    }

    /** Attach payment to a Conveyancing */
     /** Attach payment to a Conveyancing */
    public function forConveyancing(Conveyancing $conveyancing): static
    {
        return $this->state(fn() => [
            'payable_id' => $conveyancing->id,
            'payable_type' => Conveyancing::class,
            'client_id' => $conveyancing->buyer_id ?? $conveyancing->seller_id, // pick one
        ]);
    }

    /** Attach payment to a Litigation */
    public function forLitigation(Litigation $litigation): static
    {
        return $this->state(fn() => [
            'client_id' => $litigation->client_id,
            'payable_id' => $litigation->id,
            'payable_type' => Litigation::class,
        ]);
    }

    /** Attach payment to a ProjectClient */
    public function forProjectClient(ProjectClient $projectClient): static
    {
        return $this->state(fn() => [
            'client_id' => $projectClient->client_id,
            'payable_id' => $projectClient->id,
            'payable_type' => ProjectClient::class,
        ]);
    }

}
