<?php

namespace Database\Factories;

use App\Models\OfficeUtility;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\OfficeUtility>
 */
class OfficeUtilityFactory extends Factory
{
    protected $model = OfficeUtility::class;

    public function definition(): array
    {
        return [
            'type' => $this->faker->randomElement([
                'Electricity',
                'Water',
                'Internet',
                'Rent',
                'Garbage',
            ]),
            'amount' => $this->faker->randomFloat(2, 500, 10000), // Between 500 and 10,000
            'period' => $this->faker->date('Y-m'), // Format like "2025-08"
        ];
    }
}
