<?php

namespace Database\Factories;

use App\Models\LitigationPayment;
use App\Models\Litigation;
use App\Models\Client;
use App\Models\Payment;
use Illuminate\Database\Eloquent\Factories\Factory;

class LitigationPaymentFactory extends Factory
{
    protected $model = LitigationPayment::class;

    public function definition(): array
    {
        $paymentMethods = ['cash', 'mpesa', 'bank'];
        //$statuses = ['pending', 'completed', 'failed'];
        $types = ['legal_fee', 'purchase_price', 'other'];

        return [
            'litigation_id' => Litigation::factory(),
            'client_id'     => Client::factory(),
            'payment_id'    => Payment::factory(),
            'amount_paid'   => $this->faker->randomFloat(2, 1000, 100000), // e.g. between 1k and 100k
            'payment_method'=> $this->faker->randomElement($paymentMethods),
            'transaction_id'=> strtoupper($this->faker->bothify('TXN###??')), // e.g. TXN123AB
            //'status'        => $this->faker->randomElement($statuses),
            'type'          => $this->faker->randomElement($types),
        ];
    }
}
