<?php

namespace Database\Factories;

use App\Models\Litigation;
use App\Models\Client;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Litigation>
 */
class LitigationFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    protected $model = Litigation::class;
    public function definition(): array
    {
        return [
            //
            'case_number' => null, // will be auto-generated in model boot
            'court_assigned_case_number' => strtoupper($this->faker->bothify('CIV-###/####')),
            'type' => $this->faker->randomElement(['Civil', 'Criminal', 'Family', 'Commercial']),
            'status' => $this->faker->randomElement(['Open', 'Pending', 'Closed', 'Appeal']),
            'description' => $this->faker->sentence(12),
            'case_category' => $this->faker->randomElement(['Contract Dispute', 'Personal Injury', 'Property', 'Other']),
            'station' => $this->faker->city(),
            'filing_date' => $this->faker->date(),
            'client_id' => Client::factory(), // will create a related client automatically
        ];
    }
}
