<?php

namespace Database\Factories;

use App\Models\LitigationAdvocate;
use App\Models\Litigation;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\LitigationAdvocate>
 */
class LitigationAdvocateFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    protected $model =  LitigationAdvocate::class;

    public function definition(): array
    {
        return [
            //
             'litigation_id' => Litigation::factory(), // creates a related Litigation automatically
            'party'         => $this->faker->name(),
            'party_type'    => $this->faker->randomElement(['Plaintiff', 'Defendant', 'Respondent', 'Applicant']),
            'email'         => $this->faker->unique()->safeEmail(),
            'phone'         => $this->faker->phoneNumber(),
            'gender'        => $this->faker->randomElement(['Male', 'Female', 'Other']),
        ];
    }
}
