<?php

namespace Database\Factories;

use App\Models\LitigationActivity;
use App\Models\Litigation;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<LitigationActivity>
 */
class LitigationActivityFactory extends Factory
{
    protected $model = LitigationActivity::class;

    public function definition(): array
    {
        return [
            'litigation_id' => Litigation::factory(), // Creates a Litigation if not provided
            'activity' => $this->faker->sentence(4), // e.g. "Pre-trial conference"
            'activity_date' => $this->faker->dateTimeBetween('-1 years', 'now'),
            'court_room' => strtoupper($this->faker->bothify('Courtroom-##')),
            'outcome' => $this->faker->randomElement([
                'Adjourned',
                'Judgment Delivered',
                'Hearing Scheduled',
                'Dismissed',
                'Ongoing',
            ]),
        ];
    }
}
