<?php

namespace Database\Factories;

use App\Models\Invoice;
use App\Models\Client;
use Illuminate\Database\Eloquent\Factories\Factory;

class InvoiceFactory extends Factory
{
    protected $model = Invoice::class;

    public function definition(): array
    {
        return [
            'client_id'      => Client::factory(),
            'payable_type'   => null, // Polymorphic relation - set when needed
            'payable_id'     => null, // Polymorphic relation - set when needed
            'invoice_number' => null, // Auto-generated in model booted()
             'status'         => $this->faker->randomElement(['pending', 'paid', 'overdue']),
            'total_amount'   => $this->faker->randomFloat(2, 500, 20000),
            'notes'          => $this->faker->sentence(),
        ];
    }
}
