<?php
namespace Database\Factories;

use App\Models\Expense;
use App\Models\Conveyancing;
use App\Models\Litigation;
use App\Models\Project;
use Illuminate\Database\Eloquent\Factories\Factory;

class ExpenseFactory extends Factory
{
    protected $model = Expense::class;

    public function definition(): array
    {
        return [
            'expense_item_id' => \App\Models\ExpenseItem::factory(),
            'amount_paid'     => $this->faker->randomFloat(2, 100, 5000),
            'balance'         => $this->faker->randomFloat(2, 0, 2000),
            'payment_method'  => $this->faker->randomElement(['cash', 'bank', 'mpesa']),
            'status'          => $this->faker->randomElement(['pending', 'paid', 'partial']),
            'expensable_id'   => null,  // to be overridden by state
            'expensable_type' => null,  // to be overridden by state
        ];
    }

    /** Attach expense to a Conveyancing */
    public function forConveyancing(Conveyancing $conveyancing): static
    {
        return $this->state(fn() => [
            'expensable_id' => $conveyancing->id,
            'expensable_type' => Conveyancing::class,
        ]);
    }

    /** Attach expense to a Litigation */
    public function forLitigation(Litigation $litigation): static
    {
        return $this->state(fn() => [
            'expensable_id' => $litigation->id,
            'expensable_type' => Litigation::class,
        ]);
    }

    /** Attach expense to a Project */
    public function forProject(Project $project): static
    {
        return $this->state(fn() => [
            'expensable_id' => $project->id,
            'expensable_type' => Project::class,
        ]);
    }
}
