<?php

namespace Database\Factories;

use App\Models\Conveyancing;
use App\Models\Document;
use App\Models\Litigation;
use App\Models\ProjectClient;
use App\Models\ProjectDocument;
use Illuminate\Database\Eloquent\Factories\Factory;

class DocumentFactory extends Factory
{
    protected $model = Document::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->word . '.pdf',
            'file_path' => 'documents/' . $this->faker->uuid . '.pdf',
            'documentable_id' => fn() => Conveyancing::factory()->create()->id,
            'documentable_type' => Conveyancing::class,
            // serial_number is set by the booted method
        ];
    }

    /**
     * State: attach to a Conveyancing
     */
    public function forConveyancing(Conveyancing $conveyancing): static
    {
        return $this->state(fn () => [
            'documentable_id' => $conveyancing->id,
            'documentable_type' => Conveyancing::class,
        ]);
    }

    /**
     * State: attach to a Litigation
     */
    public function forLitigation(Litigation $litigation): static
    {
        return $this->state(fn () => [
            'documentable_id' => $litigation->id,
            'documentable_type' => Litigation::class,
        ]);
    }

    /**
     * State: attach to a ProjectClient
     */
    public function forProjectClient(ProjectClient $projectClient): static
    {
        return $this->state(fn () => [
            'documentable_id' => $projectClient->id,
            'documentable_type' => ProjectClient::class,
        ]);
    }

    /**
     * State: attach to a ProjectDocument
     */
    public function forProjectDocument(ProjectDocument $projectDocument): static
    {
        return $this->state(fn () => [
            'documentable_id' => $projectDocument->id,
            'documentable_type' => ProjectDocument::class,
        ]);
    }
}