<?php

namespace Database\Factories;

use App\Models\Client;
use App\Models\Conveyancing;
use App\Models\Payment;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ConveyancingPayment>
 */
class ConveyancingPaymentFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $conveyancing = Conveyancing::factory()->create();

        return [
            'client_id' => Client::factory(),
            'conveyancing_id' => $conveyancing->id,
            'amount_paid' => $this->faker->randomFloat(2, 100, 5000),
            'payment_method' => $this->faker->randomElement(['cash', 'bank', 'mpesa']),
            'transaction_id' => $this->faker->uuid(),
            //'status' => $this->faker->randomElement(['pending', 'completed', 'failed']),
            'type' => $this->faker->randomElement(['deposit', 'balance', 'fee']),
            'payment_id' => Payment::factory()->forConveyancing($conveyancing),
            'paid_by' => Client::factory(),
        ];
    }
}