<?php

namespace Database\Factories;

use App\Models\Client;
use App\Models\Conveyancing;
use Illuminate\Database\Eloquent\Factories\Factory;

class ConveyancingFactory extends Factory
{
    protected $model = Conveyancing::class;

    public function definition(): array
    {
        return [
            'client_id' => Client::factory(),
            'property_address' => $this->faker->address(),
            'seller_id' => Client::factory(),
            'buyer_id' => Client::factory(),
            'buyer_legal_fees' => $this->faker->numberBetween(1000, 5000),
            'seller_legal_fees' => $this->faker->numberBetween(1000, 5000),
            'sale_price' => $this->faker->numberBetween(100000, 1000000),
            // ✅ must match your migration constraint
            'status' => $this->faker->randomElement([
                'pending',
                'in_progress',
                'completed',
            ]),
            'contract_date' => $this->faker->date(),
            'completion_period' => $this->faker->numberBetween(14, 90),
            'notes' => $this->faker->sentence(),
        ];
    }
}
