<?php

namespace Database\Factories;

use App\Models\Conveyancing;
use App\Models\Expense;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ConveyancingExpense>
 */
class ConveyancingExpenseFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $conveyancing = Conveyancing::factory();

        return [
            'conveyancing_id' => $conveyancing,
            'expense_id' => Expense::factory()->state([
                'expensable_id' => $conveyancing,
                'expensable_type' => Conveyancing::class,
            ]),
        ];
    }
}