<?php

namespace Database\Factories;

use App\Models\Client;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Client>
 */
class ClientFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    protected $model = Client::class;
    public function definition(): array
    {
        return [
            //
            'user_id'            => User::factory(),
            'phone'              => $this->faker->phoneNumber(),
            'national_id'        => $this->faker->numerify('########'),
            'address'            => $this->faker->address(),
            'passport_number'    => $this->faker->optional()->bothify('P########'),
            'nationality'        => $this->faker->country(),
            'kra_pin'            => strtoupper($this->faker->bothify('A#######B')),
            'identification_image' => null, // you can set fake uploads if needed
        ];
    }
}
