<?php

namespace Database\Factories;

use App\Models\ApartmentDetail;
use App\Models\Project;
use App\Models\ProjectClient;
use Illuminate\Database\Eloquent\Factories\Factory;

class ApartmentDetailFactory extends Factory
{
    protected $model = ApartmentDetail::class;

    public function definition(): array
    {
        $project = Project::factory()->create();
        $projectClient = ProjectClient::factory()->for($project)->create();

        return [
            'project_id' => $project->id,
            'project_client_id' => $projectClient->id,
            'floor' => $this->faker->numberBetween(1, 10),
            'flat_name' => $this->faker->unique()->bothify('Flat ##??'),
            'amount_charged' => $this->faker->randomFloat(2, 10000, 500000),
            'owner2' => $this->faker->name(),
            'unit_type' => $this->faker->randomElement(['1-bedroom', '2-bedroom', '3-bedroom']),
        ];
    }

    public function forClient(ProjectClient $client)
    {
        return $this->state(fn(array $attributes) => [
            'project_client_id' => $client->id,
            'project_id' => $client->project_id,
        ]);
    }
}
