<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\User;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Advocate>
 */
class AdvocateFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            //
            'user_id'=>User::factory(),
            'license_number'=>$this->faker->unique()->numerify('LIC-#####'),
            'specialization'=>$this->faker->randomElement(['Civil', 'Criminal', 'Corporate', 'Property']),
            'phone'=>$this->faker->unique()->phoneNumber(),
            'national_id' => $this->faker->unique()->numerify('#########'),
            'address' =>$this->faker->address(),
        ];
    }
}
