<?php

namespace App\Providers\Filament;

use Filament\Http\Middleware\Authenticate;
use BezhanSalleh\FilamentShield\FilamentShieldPlugin;
use Filament\Http\Middleware\AuthenticateSession;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Widgets;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use Filament\Navigation\NavigationGroup;
use Filament\Navigation\NavigationItem;
use Filament\Support\Assets\Css;
use Filament\Support\Facades\FilamentAsset;
use App\Filament\Pages\Dashboard; // ✅ Custom Dashboard page
use App\Filament\Auth\Login as CustomLogin; // import for custom login

class AdminPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->default()
            ->id('admin')
            ->path('admin')
            ->login(CustomLogin::class) // replace ->login() with this           
            ->sidebarFullyCollapsibleOnDesktop()
            ->colors([
                'primary' => Color::Blue,
            ])
            ->brandLogo(asset('images/logo.png'))
            ->brandLogoHeight('4em')
            ->brandName('AYC Lawfirm MS')
            ->assets([
                Css::make('filament-custom', asset('css/filament-custom.css')),
            ])
            ->discoverResources(in: app_path('Filament/Resources'), for: 'App\\Filament\\Resources')
            ->discoverPages(in: app_path('Filament/Pages'), for: 'App\\Filament\\Pages')
            ->pages([
                Dashboard::class, // ✅ Use custom Dashboard instead of default
            ])
            ->discoverWidgets(in: app_path('Filament/Widgets'), for: 'App\\Filament\\Widgets')
            ->widgets([
                    // Keep only widgets you ALWAYS want visible on dashboard
                Widgets\AccountWidget::class,
            ])
            ->navigationGroups([
                NavigationGroup::make('Financial Management'),
            ])
            ->navigationItems([
                NavigationItem::make('Point of Sale')
                    ->url(fn() => \App\Filament\Resources\PaymentResource::getUrl('index'))
                    ->icon('heroicon-o-arrow-up-circle')
                    ->group('Financial Management')
                    ->sort(1)
                    ->visible(fn() => auth()->user()?->hasRole('admin') || auth()->user()?->hasRole('super_admin')),
                NavigationItem::make('Deposits')
                    ->url(fn() => \App\Filament\Resources\DepositResource::getUrl('index'))
                    ->icon('heroicon-o-arrow-down-circle')
                    ->group('Financial Management')
                    ->sort(2)
                    ->visible(fn() => auth()->user()?->hasRole('admin') || auth()->user()?->hasRole('super_admin')),
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->plugins([
                FilamentShieldPlugin::make(),
            ])
            ->authMiddleware([
                Authenticate::class,
            ]);
    }
}
