<?php

namespace App\Providers;

use App\Models\Advocate;
use App\Models\Client;
use App\Models\Employee;
use App\Models\Litigation;
use App\Models\Conveyancing;
use App\Models\OfficeUtility;
use App\Models\Payment;
use App\Models\Project;
use App\Models\Quotation;
use App\Models\Salary;
use App\Models\User;
use App\Policies\AccountPolicy;
use App\Policies\AdvocatePolicy;
use App\Policies\ClientPolicy;
use App\Policies\DocumentPolicy;
use App\Policies\EmployeePolicy;
use App\Policies\InvoicePolicy;
use App\Policies\LitigationPolicy;
use App\Policies\ConveyancingPolicy;
use App\Policies\OfficeUtilityPolicy;
use App\Policies\PaymentPolicy;
use App\Policies\PermissionPolicy;
use App\Policies\ProjectPolicy;
use App\Policies\QuotationPolicy;
use App\Policies\RolePolicy;
use App\Policies\SalaryPolicy;
use App\Policies\UserPolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     */
    protected $policies = [
        Litigation::class => LitigationPolicy::class,
        Conveyancing::class => ConveyancingPolicy::class,
        User::class => UserPolicy::class,
        Client::class => ClientPolicy::class,
        Advocate::class => AdvocatePolicy::class,
        Project::class =>ProjectPolicy::class,
        Role::class => RolePolicy::class,
        Permission::class => PermissionPolicy::class,
        OfficeUtility::class=>OfficeUtilityPolicy::class,
        Employee::class => EmployeePolicy::class,
        Salary::class => SalaryPolicy::class,
        Payment::class=>PaymentPolicy::class,
        Invoice::class=>InvoicePolicy::class,
        Quotation::class => QuotationPolicy::class,
        Account::class=>AccountPolicy::class,
        Document::class=>DocumentPolicy::class
        // Add more as needed...
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        $this->registerPolicies();
    }
}
