<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Salary;
use Illuminate\Auth\Access\Response;

class SalaryPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->can('view_any_salary');
    }

    public function view(User $user, Salary $salary): bool
    {
        return $user->can('view_salary');
    }

    public function create(User $user): bool
    {
        return $user->can('create_salary');
    }

    public function update(User $user, Salary $salary): bool
    {
        return $user->can('update_salary');
    }

    public function delete(User $user, Salary $salary): bool
    {
        return $user->can('delete_salary');
    }

    public function restore(User $user, Salary $salary): bool
    {
        return $user->can('restore_salary');
    }

    public function forceDelete(User $user, Salary $salary): bool
    {
        return $user->can('force_delete_salary');
    }

    public function replicate(User $user): bool
    {
        return $user->can('replicate_salary');
    }

    public function reorder(User $user): bool
    {
        return $user->can('reorder_salary');
    }
}
