<?php

namespace App\Policies;

use App\Models\User;

class PaymentPolicy
{
    /**
     * Determine whether the user can view any payments.
     */
    public function viewAny(User $user): bool
    {
        return $user->can('view_any_payment');
    }

    /**
     * Determine whether the user can view a specific payment.
     */
    public function view(User $user): bool
    {
        return $user->can('view_payment');
    }

    /**
     * Determine whether the user can create a generic payment.
     */
    public function create(User $user): bool
    {
        return $user->can('create_payment');
    }

    /**
     * Determine whether the user can update a payment.
     */
    public function update(User $user): bool
    {
        return $user->can('update_payment');
    }

    /**
     * Determine whether the user can delete a payment.
     */
    public function delete(User $user): bool
    {
        return $user->can('delete_payment');
    }

    /**
     * Determine whether the user can restore a payment.
     */
    public function restore(User $user): bool
    {
        return $user->can('restore_payment');
    }

    /**
     * Determine whether the user can force delete a payment.
     */
    public function forceDelete(User $user): bool
    {
        return $user->can('force_delete_payment');
    }

    /**
     * Determine whether the user can replicate a payment.
     */
    public function replicate(User $user): bool
    {
        return $user->can('replicate_payment');
    }

    /**
     * Determine whether the user can reorder payments.
     */
    public function reorder(User $user): bool
    {
        return $user->can('reorder_payment');
    }

    /**
     * Determine whether the user can create a deposit.
     */
    public function createDeposit(User $user): bool
    {
        return $user->can('create_deposit');
    }

    /**
     * Determine whether the user can create a point of sale.
     */
    public function createPointOfSale(User $user): bool
    {
        return $user->can('create_point_of_sale');
    }
}
