<?php

namespace App\Policies;

use App\Models\User;
use App\Models\OfficeUtility;
use Illuminate\Auth\Access\Response;

class OfficeUtilityPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->can('view_any_office_utility');
    }

    public function view(User $user, OfficeUtility $officeUtility): bool
    {
        return $user->can('view_office_utility');
    }

    public function create(User $user): bool
    {
        return $user->can('create_office_utility');
    }

    public function update(User $user, OfficeUtility $officeUtility): bool
    {
        return $user->can('update_office_utility');
    }

    public function delete(User $user, OfficeUtility $officeUtility): bool
    {
        return $user->can('delete_office_utility');
    }

    public function restore(User $user, OfficeUtility $officeUtility): bool
    {
        return $user->can('restore_office_utility');
    }

    public function forceDelete(User $user, OfficeUtility $officeUtility): bool
    {
        return $user->can('force_delete_office_utility');
    }

    public function replicate(User $user): bool
    {
        return $user->can('replicate_office_utility');
    }

    public function reorder(User $user): bool
    {
        return $user->can('reorder_office_utility');
    }
}
