<?php

namespace App\Policies;

use App\Models\Conveyancing;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class ConveyancingPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->can('view_any_conveyancing');
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Conveyancing $conveyancing): bool
    {
        return $user->can('view_conveyancing');
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return $user->can('create_conveyancing');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Conveyancing $conveyancing): bool
    {
        return $user->can('update_conveyancing');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Conveyancing $conveyancing): bool
    {
        return $user->can('delete_conveyancing');
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, Conveyancing $conveyancing): bool
    {
        return $user->can('restore_conveyancing');
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, Conveyancing $conveyancing): bool
    {
        return $user->can('force_delete_conveyancing');
    }

    /**
     * Determine whether the user can replicate the model.
     */
    public function replicate(User $user): bool
    {
        return $user->can('replicate_conveyancing');
    }

    /**
     * Determine whether the user can reorder models.
     */
    public function reorder(User $user): bool
    {
        return $user->can('reorder_conveyancing');
    }
}
