<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Advocate;
use Illuminate\Auth\Access\HandlesAuthorization;

class AdvocatePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any advocates.
     */
    public function viewAny(User $user): bool
    {
        return $user->can('view_any_advocate');
    }

    /**
     * Determine whether the user can view the advocate.
     */
    public function view(User $user, Advocate $advocate): bool
    {
        return $user->can('view_advocate');
    }

    /**
     * Determine whether the user can create advocates.
     */
    public function create(User $user): bool
    {
        return $user->can('create_advocate');
    }

    /**
     * Determine whether the user can update the advocate.
     */
    public function update(User $user, Advocate $advocate): bool
    {
        return $user->can('update_advocate');
    }

    /**
     * Determine whether the user can delete the advocate.
     */
    public function delete(User $user, Advocate $advocate): bool
    {
        return $user->can('delete_advocate');
    }

    /**
     * Determine whether the user can restore the advocate.
     */
    public function restore(User $user, Advocate $advocate): bool
    {
        return $user->can('restore_advocate');
    }

    /**
     * Determine whether the user can permanently delete the advocate.
     */
    public function forceDelete(User $user, Advocate $advocate): bool
    {
        return $user->can('force_delete_advocate');
    }

    /**
     * Determine whether the user can replicate the advocate.
     */
    public function replicate(User $user): bool
    {
        return $user->can('replicate_advocate');
    }

    /**
     * Determine whether the user can reorder advocates.
     */
    public function reorder(User $user): bool
    {
        return $user->can('reorder_advocate');
    }
}
