<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Account;

class AccountPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->can('view_any_account');
    }

    public function view(User $user, Account $account): bool
    {
        return $user->can('view_account');
    }

    public function create(User $user): bool
    {
        return $user->can('create_account');
    }

    public function update(User $user, Account $account): bool
    {
        return $user->can('update_account');
    }

    public function delete(User $user, Account $account): bool
    {
        return $user->can('delete_account');
    }

    public function forceDelete(User $user, Account $account): bool
    {
        return $user->can('force_delete_account');
    }

    public function restore(User $user, Account $account): bool
    {
        return $user->can('restore_account');
    }

    public function replicate(User $user, Account $account): bool
    {
        return $user->can('replicate_account');
    }

    public function reorder(User $user): bool
    {
        return $user->can('reorder_account');
    }
}
