<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubDivisionDetail extends Model
{
    //
    use HasFactory,SoftDeletes;
    protected $fillable = [
        'project_id',
        'project_client_id',
        'plot_number',
        'size',
        "amount_charged",
        'owner2',
    ];     //relationship with projects
    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }

    //relationship with project client
    public function projectClient():BelongsTo{
        return $this->belongsTo(ProjectClient::class);
    }
}

