<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Quotation extends Model
{
    use HasFactory, SoftDeletes;
    //fillable fields
    protected $fillable = [
        'quote_number',
        'client_id',
        'type',          // 'conveyancing', 'litigation', or 'project'
        'details',       // Optional description or summary
        'amount',        // Total quoted amount
        'quote_date',
    ];

    public function client(): BelongsTo
    {
        return $this->belongsTo(Client::class);
    }

    protected static function booted()
    {
        static::created(function (Quotation $quotation) {
            if (empty($quotation->quote_number)) {
                $quotation->quote_number = 'AYC/QT/' . str_pad($quotation->id, 3, '0', STR_PAD_LEFT);
                $quotation->saveQuietly(); // silent update without events
            }
        });
    }

    //to cast a field to a particular type
    protected $casts = [
        'quote_date' => 'datetime',
    ];

}
