<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectExpense extends Model
{
    use HasFactory,SoftDeletes;
    protected $fillable = [
        "project_id",
       "expense_id",
    ];

    public function project():BelongsTo{
        return $this->belongsTo(Project::class);
    }

      public function expense(): BelongsTo
    {
        return $this->belongsTo(Expense::class);
    }
}

