<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectClientPayment extends Model
{
    use HasFactory,SoftDeletes;
    protected $fillable = [
        "project_client_id",
        "amount_paid",
        "payment_id",
        "payment_method",
        "transaction_id",
        //"status",
        //"type" // Add this to indicate payment purpose (e.g. legal fees, purchase price)
    ];
    //relationship with project client

    public function projectClient():BelongsTo{
        return $this->belongsTo(ProjectClient::class);
    }
     public function payment(): BelongsTo
    {
        return $this->belongsTo(Payment::class);
    }


}

