<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use App\Traits\HasDocuments;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectClient extends Model
{
    //
    use HasDocuments,SoftDeletes,HasFactory;
    protected $fillable = [
        'project_id',
        'client_id',
    ];
    //relationship between projectclient and client
    public function client(): BelongsTo
    {
        return $this->belongsTo(Client::class);
    }

    //relationship between project clirnt and projects
    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }

    //relationship with project client documents
    public function documents(): MorphMany
    {
        return $this->morphMany(Document::class, 'documentable');
    }
    
    public function projectClientPayments(): HasMany
    {
        return $this->hasMany(ProjectClientPayment::class);
    }
    
    public function projectClientDocuments(): HasMany
    {
        return $this->hasMany(ProjectClientDocument::class);
    }

    

    //relationship to apartment detail
    public function apartmentDetail():HasOne{
        return $this->hasOne(ApartmentDetail::class,'project_client_id');
    }

    //relationship with subdivision detail
    public function subdivisionDetail():HasOne{
        return $this->hasOne(SubDivisionDetail::class,'project_client_id');
    }
}

