<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payment extends Model
{
    //
    use HasFactory,SoftDeletes;
    protected $fillable = [
        'client_id',
        'payable_id',
        'payable_type',
        'amount_paid',
        'payment_method',
        'transaction_id',
        'direction',
        ];

    //relationship between payments and clients
    public function client():BelongsTo{
        return $this->belongsTo(Client::class);
    }

    public function account(): BelongsTo
    {
        return $this->belongsTo(Account::class);
    }

    public function payable(): MorphTo
    {
        return $this->morphTo();
    }

}

