<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class LitigationPayment extends Model
{
    use HasFactory,SoftDeletes;

    protected $fillable = ['litigation_id',
    'client_id',
    'amount_paid',
    'payment_method',
    'transaction_id',
    //'status',
    'type',
    'payment_id'];
    //relationship between litigation and litigation payments
    public function litigation():BelongsTo{
        return $this->belongsTo(Litigation::class);
    }

    //relationship with clients
    public function client():BelongsTo{
        return $this->belongsTo(Client::class);
    }

     public function payment(): BelongsTo
    {
        return $this->belongsTo(Payment::class);
    }
}
