<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class LitigationExpense extends Model
{
    //
    use HasFactory,SoftDeletes;
     protected $fillable = [
        "litigation_id",
        "expense_id",
    ];

    public function litigation():BelongsTo{
        return $this->belongsTo(Litigation::class);
    }

     public function expense(): BelongsTo
    {
        return $this->belongsTo(Expense::class);
    }

}
