<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class LitigationCaseType extends Model
{
    //
    use HasFactory,SoftDeletes;

    protected $fillable = ['name'];

    //relationship with litigation
    public function litigations():HasMany{
        return $this->hasMany(Litigation::class);
    }
}
