<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class LitigationAdvocate extends Model
{
    use HasFactory,SoftDeletes;
    //
    protected $fillable = [
        'litigation_id',
        'party',
        'party_type',
        'email',
        'phone',
        'gender',
    ];

    //relationship with litigations
    public function litigation():BelongsTo{
        return $this->belongsTo(Litigation::class);
    }

}
