<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class LitigationActivity extends Model
{
    //
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'litigation_id',
        'activity',
        'activity_date',
        'court_room',
        'outcome',
    ];
    //relationship with litigation
    public function litigation(): BelongsTo
    {
        return $this->belongsTo(Litigation::class);
    }


    
    

}
