<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Expense extends Model
{
    //
    use HasFactory,SoftDeletes;
      protected $fillable = [
        'expense_item_id',
        'amount_paid',
        'client_id',
        'balance',
        'payment_method',
        'status',
        'expensable_id',
        'expensable_type',
    ];

     public function expenseItem(): BelongsTo
    {
        return $this->belongsTo(ExpenseItem::class);
    }

     //relationship with clients
    public function client():BelongsTo{
        return $this->belongsTo(Client::class);
    }


    public function expensable(): MorphTo
    {
        return $this->morphTo();
    }
}
