<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employee extends Model
{
    use HasFactory,SoftDeletes;
    protected $fillable = ['name', 'email', 'employee_id'];

    protected static function booted()
    {
        static::created(function (Employee $employee) {
            if (empty($employee->employee_id)) {
                $employee->employee_id = 'AYC/EMP/' . str_pad($employee->id, 4, '0', STR_PAD_LEFT);
                $employee->saveQuietly(); // avoids triggering events again
            }
        });
    }
}
