<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class ConveyancingPayment extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'client_id',
        'conveyancing_id',
        'amount_paid',
        'payment_method',
        'transaction_id',
        'type',
        'payment_id',
        'paid_by'
    ];
    //relationship between payment and conveyancing
    public function conveyancing(): BelongsTo
    {
        return $this->belongsTo(Conveyancing::class);
    }

    //relationship with clients
    public function client(): BelongsTo
    {
        return $this->belongsTo(Client::class);
    }

    public function payment(): BelongsTo
    {
        return $this->belongsTo(Payment::class);
    }

    //know who paid
    public function paidBy(): BelongsTo
    {
        return $this->belongsTo(Client::class, 'paid_by');
    }
}
