<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class ConveyancingExpense extends Model
{
    
    //
    use HasFactory,SoftDeletes;
    protected $fillable = [
        "conveyancing_id",
        "expense_id",
    ];

    //relationship with conveynacing
    public function conveyancing():BelongsTo{
        return $this->belongsTo(Conveyancing::class);
    }

     public function expense(): BelongsTo
    {
        return $this->belongsTo(Expense::class);
    }
}
